<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Restaurant extends Model 
{

    protected $table = 'restaurants';
    public $timestamps = true;
    protected $fillable = array('name', 'email', 'image', 'address', 'phone', 'lang', 'lat', 'rate', 'status', 'from', 'to', 'category_id');

    public function restaurant_category()
    {
        return $this->belongsTo('App\Models\RestaurantCategory');
    }

    public function products()
    {
        return $this->hasMany('App\Models\Product');
    }

    public function orders()
    {
        return $this->hasMany('App\Models\Order');
    }

    public function restaurant_reviews()
    {
        return $this->hasMany('App\Models\RestaurantReview');
    }

}